//
//  MCTouchChangeManager.h
//  MCClientServer
//
//  Created by Brent Gulanowski on 10-03-22.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//


#import <MCClientServer/MCServerChangeManager.h>


extern NSString *kMCSIncomingFolderName;
extern NSString *kMCSTransmitFolderName;


@class MCChangeSet;

@interface MCTouchChangeManager : MCServerChangeManager {

	MCChangeSet *incomingChanges;
	MCChangeSet *changesToTransmit; // = reconciledOutgoing
}

@property (retain) MCChangeSet *incomingChanges;
@property (retain) MCChangeSet *changesToTransmit;

- (NSString *)incomingChangeSetFolder;
- (NSString *)transmitChangeSetFolder;

- (NSString *)uniqueIncomingChangeSetPath;
- (NSString *)uniqueTransmitChangeSetPath;

- (MCChangeSet *)newAutoreleasedIncomingChangeSet;
- (MCChangeSet *)newAutoreleasedTransmitChangeSet;

- (void)appendIncomingChanges:(MCChangeSet *)newChanges;

@end
